-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.mTCounter = 0
    end
        
    self.mTownHandler:LinkToTarget("mTown")
	  self.mTownHandler:LinkToTarget("mTownReinf")
  end
  
  if self.mTCounter == 3 then
    self.mTownHandler:TriggerAllTargets()
    MarkMainGoal(self)
	  self.mTCounter = 0
  end
end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("smallTown"):GetPosition().x
  gPosY = Game:GetEntity("smallTown"):GetPosition().y

  self.p0:SetQuestPosition('D9G_GOAL_2', gPosX, gPosY)
end

function OnTrigger(self, source, target)
  if target == "mTownBuildings" then
    self.mTCounter = self.mTCounter + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.mTCounter = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.mTCounter)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("mTownBuildings")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("mTownHandler")
end
